*** rt-ssur3.do
*** v1.2
***
*** Creates SSUR-3 forecasts from q-time data. Outputs f_NNN s_NNN ur_NNN, where NNN is
***   the date of the first forecast for the UR (i.e., the unemployment rate is known through
***   month NNN-1). NNN is the Stata date code for months, where 192 = 1976m1.
***
clear all
set more off
set type double
set matsize 1000

global path = "$HOME/research/ssur"

tempfile ssur_data
insheet using $path/bpea/ssur_data_bpea.csv, comma clear
gen int mdate = tm(1951m1)+_n-1
order mdate
drop v1
unab foo: *
foreach var of local foo {
  qui destring `var', replace force
}
tsset mdate, m
drop u_s f s
keep if mdate>=tm(1967m7)

cap erase fhist-ssur3.dta
!rm *.out

local i = 1
preserve
forvalues rdate = 192/631 {
  noi disp "$S_DATE $S_TIME " %tm `rdate'
  restore, preserve
  outsheet mdate e u n p eur enr uer unr ner nur hwi uic if mdate<=`rdate'-1 using foo.csv, comma replace nonames
  !echo ",E,U,N,P,EUR,ENR,UER,UNR,NER,NUR,HWI,UIC" > input.csv
  !cat foo.csv >> input.csv
  !rats qrt-ssur3.prg qrt-ssur3-`rdate'.out
  insheet using output.csv, comma clear
  gen int mdate=tm(1967m7)+_n-1
  drop v1
  order mdate
  unab foo: *
  local bar: subinstr local foo "mdate" "", all
  foreach var of local bar {
    rename `var' `var'_`rdate'
  }
  if `i'>1 {
    merge 1:1 mdate using fhist-ssur3.dta, nogen
  }
  compress
  save fhist-ssur3.dta, replace
  local i=`++i'
}
restore, not

use fhist-ssur3.dta, replace
keep mdate ur_* lfpr_*
reshape long ur_ lfpr_, i(mdate) j(fcdate)
rename ur_ ur_ssur3
rename lfpr lfpr_ssur3
order fcdate mdate
sort fcdate mdate
format %tm *date
drop if ur==.
compress
save qrt-ssur3.dta, replace

* clean up
!gzip -f9 fhist-ssur3.dta
erase foo.csv
erase input.csv
erase output.csv
!tar czf qrt-ssur3-logs.tar.gz qrt-ssur3-*.out
!rm qrt-ssur3-*.out

if "$S_CONSOLE"=="console" exit, STATA clear
